<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.seolaxy.com/
 * @since             0.0.1
 * @package           Seolaxy_Linkjuice
 *
 * @wordpress-plugin
 * Plugin Name:       SEOLAXY Link Juice Control
 * Plugin URI:        https://www.seolaxy.com/
 * Description:       This plugin automatically manages internal and external links, ensuring maximum link equity (link juice) distribution across your pages.
 * Version:           1.0.6
 * Author:            SEOLAXY
 * Author URI:        https://www.seolaxy.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       seolaxy-linkjuice
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
  die;
}

define('SEOLAXY_LINKJUICE_PATH', plugin_dir_path(__FILE__));
define('SEOLAXY_LINKJUICE_URL', plugin_dir_url(__FILE__));
define('SEOLAXY_LINKJUICE_VERSION', '1.0.6');

require 'plugin-update-checker-5.5/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
  'https://plugins-cdn.seolaxy.com/linkjuice/version.json',
  __FILE__,
  'seolaxy-linkjuice'
);

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-seolaxy-linkjuice-activator.php
 */
function activate_seolaxy_linkjuice()
{
  require_once SEOLAXY_LINKJUICE_PATH . 'includes/class-seolaxy-linkjuice-activator.php';
  Seolaxy_Linkjuice_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-seolaxy-linkjuice-deactivator.php
 */
function deactivate_seolaxy_linkjuice()
{
  require_once SEOLAXY_LINKJUICE_PATH . 'includes/class-seolaxy-linkjuice-deactivator.php';
  Seolaxy_Linkjuice_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_seolaxy_linkjuice');
register_deactivation_hook(__FILE__, 'deactivate_seolaxy_linkjuice');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require SEOLAXY_LINKJUICE_PATH . 'includes/class-seolaxy-linkjuice.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * WOOCOMMERCE COMPATIBILITY:
 * This plugin is designed to work with or without WooCommerce.
 * WooCommerce-specific features are handled gracefully when WooCommerce is not active.
 * The plugin uses safe helper methods and WordPress core functions to avoid fatal errors.
 *
 * Protection implemented:
 * - WoocommerceHelpers class with safe parameter checking
 * - Robust WooCommerce detection using function_exists() and class_exists()
 * - WordPress core functions (is_tax) instead of WooCommerce-specific functions
 * - Automatic WooCommerce status tracking in plugin options
 *
 * @since    1.0.0
 */
function run_seolaxy_linkjuice()
{

  $plugin = new Seolaxy_Linkjuice();
  $plugin->run();
}
run_seolaxy_linkjuice();
