<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

/**
 * WooCommerce helper functions for the linkjuice plugin.
 *
 * @package    Seolaxy_Linkjuice
 * @subpackage Seolaxy_Linkjuice/public/helpers
 */
class WoocommerceHelpers
{

  /**
   * Check if WooCommerce plugin is active and properly loaded.
   *
   * @since 1.0.0
   * @return bool True if WooCommerce is active, false otherwise
   */
  public static function is_woocommerce_activated()
  {
    // Use the main plugin function for consistency
    if (function_exists('seolaxy_linkjuice_is_woocommerce_active')) {
      return seolaxy_linkjuice_is_woocommerce_active();
    }
    // Fallback if function not loaded yet
    return function_exists('WC') && class_exists('WooCommerce');
  }

  /**
   * Check if orderby parameter is set in the URL.
   *
   * @since 1.0.0
   * @return bool True if orderby is set, false otherwise
   */
  public static function is_orderby_set()
  {
    return isset($_GET['orderby']);
  }

  /**
   * Get the count of applied WooCommerce filters from URL parameters.
   *
   * @since 1.0.0
   * @return int Number of applied filters
   */
  public static function get_applied_filters_count()
  {
    $count = 0;

    // Safely check $_GET parameters
    if (!empty($_GET)) {
      foreach ($_GET as $key => $value) {
        if (strpos($key, 'filter_') !== false && !empty($value)) {
          $values = explode(',', sanitize_text_field($value));
          $count += count($values);
        }
      }
    }

    return $count;
  }
}
