<?php
class Common
{
  /**
   * Check if page is paginated and if the page is greter then first page
   * return bool
   */
  public static function isPaginated()
  {
    if (get_query_var('paged') && get_query_var('paged') > 1) {
      return true;
    } else {
      return false;
    }
  }

  public static function getCurrentUrl()
  {
    return (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
  }

  public static function removePagingFromUrl($url)
  { //TODO - check if /page is for pagination, this could be changed
    return preg_replace('/\/page\/\d+\//', '/', $url);;
  }

  public static function removeGetParamsFromUrl($url)
  {
    if (!empty($_GET)) {
      $parsedUrl = parse_url($url);
      $url = $parsedUrl['scheme'] . '://' . $parsedUrl['host'];

      if (isset($parsedUrl['port'])) {
        $url .= ':' . $parsedUrl['port'];
      }
      
      if (isset($parsedUrl['path'])) {
        $url .= $parsedUrl['path'];
      }
    }
    return $url;
  }
}
