<?php
require_once SEOLAXY_LINKJUICE_PATH . 'public/Robots/RobotsData.php';
require_once SEOLAXY_LINKJUICE_PATH . 'public/helpers/Common.php';
require_once SEOLAXY_LINKJUICE_PATH . 'public/helpers/Woocommerce.php';
class Robots
{
  static function getRobotsByLinkjuice($linkjuice_settings)
  {
    $robots = new RobotsData();
    $isPaginated = Common::isPaginated();
    $applied_filters_count = WoocommerceHelpers::get_applied_filters_count();
    $is_orderby_set = WoocommerceHelpers::is_orderby_set();

    if (is_tax('product_cat')) {
      $robots->setContent($linkjuice_settings->ProductCategoryPage);
      if ($isPaginated) {
        $robots->setContent($linkjuice_settings->ProductCategoryPaging);
      }

      $cat = get_queried_object();
      if ($cat->parent > 0) { //subcategory
        $robots->setContent($linkjuice_settings->ProductSubactegoryPage);
        if ($isPaginated) {
          $robots->setContent($linkjuice_settings->ProductSubactegoryPaging);
        }
      }
    }

    //Single Filter
    if ($applied_filters_count === 1) {
      $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategorySingleFilterPage);
      if ($isPaginated) {
        $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategorySingleFilterPaging);
      }
    } elseif ($applied_filters_count > 1) { //Multiple filters
      $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategoryMultipleFilterPage);
      if ($isPaginated) {
        $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategoryMultipleFilterPaging);
      }
    }

    if ($is_orderby_set) {
      $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategorySort);
      if ($isPaginated) {
        $robots->setContent($linkjuice_settings->ProductCategoryAndSubCategorySortPaging);
      }
    }

    if (is_search()) {
      $robots->setContent($linkjuice_settings->Search);
    }

    return $robots;
  }
}
