<?php
require_once SEOLAXY_LINKJUICE_PATH . 'public/helpers/Common.php';
require_once SEOLAXY_LINKJUICE_PATH . 'public/helpers/Woocommerce.php';
require_once SEOLAXY_LINKJUICE_PATH . 'public/Canonical/CanonicalData.php';
class Canonical
{
  static function getCanonicalByLinkjuice($linkjuice_settings)
  {
    $link = Common::getCurrentUrl();
    $canonical = new CanonicalData($link);
    $isPaginated = Common::isPaginated();
    $applied_filters_count = WoocommerceHelpers::get_applied_filters_count();
    $is_orderby_set = WoocommerceHelpers::is_orderby_set();

    if (is_tax('product_cat')) {
      $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryCanonical);
      if ($isPaginated) {
        $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryPagingCanonical);
      }
      $canonical->setHref($canonical_link);

      $cat = get_queried_object();
      if ($cat->parent > 0) { //subcategory
        $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductSubcategoryCanonical);
        if ($isPaginated) {
          $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductSubcategoryPagingCanonical);
        }
        $canonical->setHref($canonical_link);
      }
    }

    //Single Filter
    if ($applied_filters_count === 1) {
      $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategorySingleFilterCanonical);
      if ($isPaginated) {
        $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategorySingleFilterPagingCanonical);
      }
      $canonical->setHref($canonical_link);
    } elseif ($applied_filters_count > 1) { //Multiple filters
      $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategoryMultipleFilterPageCanonical);
      if ($isPaginated) {
        $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategoryMultipleFilterPagingCanonical);
      }
      $canonical->setHref($canonical_link);
    }

    if ($is_orderby_set) {
      $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategorySortCanonical);
      if ($isPaginated) {
        $canonical_link = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->ProductCategoryAndSubCategorySortPagingCanonical);
      }
      $canonical->setHref($canonical_link);
    }

    if (is_search()) {
      $home_url = self::setCanonicalUrlBasedOnSettings($link, $linkjuice_settings->SearchCanonical);;
      $canonical->setHref($home_url);
    }
    return $canonical;
  }

  private static function setCanonicalUrlBasedOnSettings($link, $settings)
  {
    $canonical_url = $link;
    if ($settings === 'root') {
      $canonical_url = Common::removeGetParamsFromUrl($link);
      $canonical_url = Common::removePagingFromUrl($canonical_url);
    } else if ($settings === 'home') {
      $canonical_url = get_home_url();
    }

    return $canonical_url;
  }
}
