<?php

/**
 * Get the Plugin Default Options.
 *
 * @since 1.0.0
 *
 * @param null
 *
 * @return array Default Options
 *
 * @author     SEOLAXY
 *
 */
if (!function_exists('seolaxy_linkjuice_default_options')):
  function seolaxy_linkjuice_default_options()
  {
    $default_theme_options = array(
      'LicenseKey' => esc_html('NO'),
      'linkjuice_adjustment' => esc_html('default'),
      'ProductCategoryPage' => esc_html('index,follow'),
      'ProductCategoryCanonical' => esc_html('root'),
      'ProductCategoryPaging' => esc_html('index,follow'),
      'ProductCategoryPagingCanonical' => esc_html('root'),
      'ProductSubactegoryPage' => esc_html('index,follow'),
      'ProductSubcategoryCanonical' => esc_html('root'),
      'ProductSubactegoryPaging' => esc_html('index,follow'),
      'ProductSubcategoryPagingCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategorySingleFilterPage' => esc_html('index,follow'),
      'ProductCategoryAndSubCategorySingleFilterCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategorySingleFilterPaging' => esc_html('index,follow'),
      'ProductCategoryAndSubCategorySingleFilterPagingCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategoryMultipleFilterPage' => esc_html('index,follow'),
      'ProductCategoryAndSubCategoryMultipleFilterPageCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategoryMultipleFilterPaging' => esc_html('index,follow'),
      'ProductCategoryAndSubCategoryMultipleFilterPagingCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategorySort' => esc_html('index,follow'),
      'ProductCategoryAndSubCategorySortCanonical' => esc_html('root'),
      'ProductCategoryAndSubCategorySortPaging' => esc_html('index,follow'),
      'ProductCategoryAndSubCategorySortPagingCanonical' => esc_html('root'),
      'Search' => esc_html('index,follow'),
      'SearchCanonical' => esc_html('root'),
      'woocommerce_active' => false, // Will be updated by hooks after plugins are loaded
    );

    return apply_filters('seolaxy_linkjuice_default_options', $default_theme_options);
  }
endif;

/**
 * Get the Plugin Saved Options.
 *
 * @since 1.0.0
 *
 * @param string $key optional option key
 *
 * @return mixed All Options Array Or Options Value
 *
 * @author     SEOLAXY
 *
 */
if (!function_exists('seolaxy_linkjuice_get_options')):
  function seolaxy_linkjuice_get_options($key = '')
  {
    $options = get_option('seolaxy_linkjuice_options');
    $default_options = seolaxy_linkjuice_default_options();

    if (!empty($key)) {
      if (isset($options[$key])) {
        // Special handling for LicenseKey - return "no" if empty
        if ($key === 'LicenseKey' && empty($options[$key])) {
          return "no";
        }
        return $options[$key];
      }
      return isset($default_options[$key]) ? $default_options[$key] : false;
    } else {
      if (!is_array($options)) {
        $options = array();
      }
      return array_merge($default_options, $options);
    }
  }
endif;

function seolaxy_linkjuice_fix_schema($option_group, $option_name, $args)
{
  if ($option_name === 'seolaxy_linkjuice_options') {
    $my_options = get_option($option_name, $args['default']);
    $my_options_keys = array_keys($my_options);

    $schema_properties = $args['show_in_rest']['schema']['properties'];
    $schema_properties_keys = array_keys($schema_properties);

    $different_keys = array_diff($my_options_keys, $schema_properties_keys);
    if ($different_keys) {
      foreach ($different_keys as $key) {
        unset($my_options[$key]);
      }
      update_option($option_name, $my_options);
    }
  }
}
add_action('register_setting', 'seolaxy_linkjuice_fix_schema', 10, 3);

/**
 * Check if WooCommerce plugin is active.
 *
 * @since 1.0.0
 *
 * @return bool True if WooCommerce is active, false otherwise
 *
 * @author     SEOLAXY
 *
 */
if (!function_exists('seolaxy_linkjuice_is_woocommerce_active')) :
  function seolaxy_linkjuice_is_woocommerce_active()
  {
    return function_exists('WC') && class_exists('WooCommerce');
  }
endif;

/**
 * Update WooCommerce status in options when plugins are activated/deactivated
 *
 * @since 1.0.0
 *
 * @author     SEOLAXY
 *
 */
function seolaxy_linkjuice_update_woocommerce_status()
{
  $options = get_option('seolaxy_linkjuice_options', array());
  $options['woocommerce_active'] = seolaxy_linkjuice_is_woocommerce_active();
  update_option('seolaxy_linkjuice_options', $options);
}

// Hook into plugin activation/deactivation to update WooCommerce status
add_action('activated_plugin', 'seolaxy_linkjuice_update_woocommerce_status');
add_action('deactivated_plugin', 'seolaxy_linkjuice_update_woocommerce_status');

// Also update on plugin init to ensure status is current
add_action('plugins_loaded', 'seolaxy_linkjuice_update_woocommerce_status', 999);
