<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.seolaxy.com/
 * @since             0.0.1
 * @package           Seolaxy_Ctr
 *
 * @wordpress-plugin
 * Plugin Name:       Seolaxy CTR for WordPress
 * Plugin URI:        https://www.seolaxy.com/
 * Description:       Maximize your Wordpress click-through rates (CTR) with CTR our plugin, it will help you optimize content, meta titles, and descriptions to attract more clicks from search engine results.
 * Version:           0.2.5
 * Author:            SEOLAXY
 * Author URI:        https://www.seolaxy.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       seolaxy-ctr
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
  die;
}

/**
 * Current plugin path.
 * Current plugin url.
 * Current plugin version.
 *
 * Rename these constants for your plugin
 * Update version as you release new versions.
 */

define('SEOLAXY_CTR_PATH', plugin_dir_path(__FILE__));
define('SEOLAXY_CTR_URL', plugin_dir_url(__FILE__));
define('SEOLAXY_CTR_VERSION', '0.2.5');

require 'plugin-update-checker-5.5/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
  'https://plugins-cdn.seolaxy.com/ctr/version.json',
  __FILE__,
  'seolaxy-ctr'
);

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-seolaxy-ctr-activator.php
 */
function activate_seolaxy_ctr()
{
  require_once SEOLAXY_CTR_PATH . 'includes/class-seolaxy-ctr-activator.php';
  Seolaxy_Ctr_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-seolaxy-ctr-deactivator.php
 */
function deactivate_seolaxy_ctr()
{
  require_once SEOLAXY_CTR_PATH . 'includes/class-seolaxy-ctr-deactivator.php';
  Seolaxy_Ctr_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_seolaxy_ctr');
register_deactivation_hook(__FILE__, 'deactivate_seolaxy_ctr');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require SEOLAXY_CTR_PATH . 'includes/class-seolaxy-ctr.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_seolaxy_ctr()
{

  $plugin = new Seolaxy_Ctr();
  $plugin->run();
}
run_seolaxy_ctr();
