<?php

/**
 * Handles all title tag related functionality
 *
 * @package    Seolaxy_Ctr
 * @subpackage Seolaxy_Ctr/includes/services
 */
class Seolaxy_Ctr_Title_Service {
    private $options;
    private $logger;
    private $pattern_service;

    public function __construct($options, $logger, $pattern_service) {
        $this->options = $options;
        $this->logger = $logger;
        $this->pattern_service = $pattern_service;
    }

    /**
     * Get title tag based on current page context
     */
    public function get_title_tag() {
        try {
            if (is_front_page()) {
                return $this->options['homepage_title_tag'] ?? '';
            }

            if (is_category()) {
                return $this->get_category_title();
            }

            if (is_single() && isset($this->options['post_title_tag_pattern'])) {
                return $this->pattern_service->replace_patterns($this->options['post_title_tag_pattern']);
            }

            if (is_page() && isset($this->options['page_title_tag_pattern'])) {
                return $this->pattern_service->replace_patterns($this->options['page_title_tag_pattern']);
            }

            if (is_tag() && isset($this->options['tag_title_tag_pattern'])) {
                return $this->pattern_service->replace_patterns($this->options['tag_title_tag_pattern']);
            }

            return '';
        } catch (Exception $e) {
            $this->logger->error('Error getting title tag: ' . $e->getMessage());
            return '';
        }
    }

    /**
     * Get category title
     */
    private function get_category_title() {
        $queried_object = get_queried_object();
        if (!$queried_object) {
            return '';
        }

        $category_slug = $queried_object->slug;
        return $this->options['category_meta'][$category_slug]['meta_title'] ?? '';
    }

    /**
     * Filter WordPress title parts
     */
    public function filter_title_parts($title_parts) {
        $title = $this->get_title_tag();
        if ($title) {
            $title_parts['title'] = $title;
        }
        
        // Remove default parts as per requirements
        unset($title_parts['site']);
        unset($title_parts['tagline']);
        
        return $title_parts;
    }
} 