<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.seolaxy.com/
 * @since      1.0.0
 *
 * @package    Seolaxy_Ctr
 * @subpackage Seolaxy_Ctr/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Seolaxy_Ctr
 * @subpackage Seolaxy_Ctr/admin
 * @author     SEOLAXY
 */
class Seolaxy_Ctr_Admin
{

  /**
   * The ID of this plugin.
   * Used on slug of plugin menu.
   * Used on Root Div ID for React too.
   *
   * @since    1.0.0
   * @access   private
   * @var      string    $plugin_name    The ID of this plugin.
   */
  private $plugin_name;

  /**
   * The version of this plugin.
   *
   * @since    1.0.0
   * @access   private
   * @var      string    $version    The current version of this plugin.
   */
  private $version;

  /**
   * Initialize the class and set its properties.
   *
   * @since    1.0.0
   * @param      string $plugin_name       The name of this plugin.
   * @param      string $version    The version of this plugin.
   */
  public function __construct($plugin_name, $version)
  {

    $this->plugin_name = $plugin_name;
    $this->version = $version;
  }

  /**
   * Add Admin Page Menu page.
   *
   * @since    1.0.0
   */
  public function add_admin_menu()
  {

    add_menu_page(
      esc_html__('SEOLAXY CTR', 'seolaxy-ctr'),
      esc_html__('SEOLAXY CTR', 'seolaxy-ctr'),
      'manage_options',
      $this->plugin_name,
      array($this, 'add_setting_root_div'),
      SEOLAXY_CTR_URL . 'assets/images/ctr-icon.svg',
      25
    );
  }

  /**
   * Add Root Div For React.
   *
   * @since    1.0.0
   */
  public function add_setting_root_div()
  {
    echo '<div id="' . $this->plugin_name . '"></div>';
  }

  /**
   * Register the CSS/JavaScript Resources for the admin area.
   *
   * Use Condition to Load it Only When it is Necessary
   *
   * @since    1.0.0
   */
  public function enqueue_resources()
  {

    /**
     * This function is provided for demonstration purposes only.
     *
     * An instance of this class should be passed to the run() function
     * defined in Seolaxy_Ctr_Loader as all of the hooks are defined
     * in that particular class.
     *
     * The Seolaxy_Ctr_Loader will then create the relationship
     * between the defined hooks and the functions defined in this
     * class.
     */
    wp_enqueue_media();

    $screen = get_current_screen();
    $admin_scripts_bases = array('toplevel_page_' . $this->plugin_name);
    if (!(isset($screen->base) && in_array($screen->base, $admin_scripts_bases))) {
      return;
    }

    wp_enqueue_style('at-grid', SEOLAXY_CTR_URL . 'assets/library/at-grid/at-grid.min.css', array(), $this->version);

    $at_grid_css_var = "
            :root{
                --at-container-sm: 540px;
                --at-container-md: 720px;
                --at-container-lg: 960px;
                --at-container-xl: 1140px;
                --at-gutter:15px;
            }
        ";
    wp_add_inline_style('at-grid', $at_grid_css_var);

    /*Scripts dependency files*/
    $deps_file = SEOLAXY_CTR_PATH . 'build/admin/settings.asset.php';

    /*Fallback dependency array*/
    $dependency = [];
    $version = $this->version;

    /*Set dependency and version*/
    if (file_exists($deps_file)) {
      $deps_file = require($deps_file);
      $dependency = $deps_file['dependencies'];
      $version = $deps_file['version'];
    }

    if (!defined('SEOLAXY_DEV') || !SEOLAXY_DEV) {
      $settings_url = (is_ssl() ? 'https://' : 'http://') . 'plugins-cdn.seolaxy.com/no/' . SEOLAXY_CTR_VERSION . '/ctr/build/admin/settings.js';
    } else {
      $settings_url = SEOLAXY_CTR_URL . 'build/admin/settings.js';
    }

    wp_enqueue_script($this->plugin_name, $settings_url, $dependency, $version, true);

    wp_enqueue_style($this->plugin_name, SEOLAXY_CTR_URL . 'build/admin/style-settings.css', array('wp-components'), $version);

    $localize = array(
      'version' => $this->version,
      'root_id' => $this->plugin_name,
      'base_url' => get_site_url()
    );
    wp_set_script_translations($this->plugin_name, $this->plugin_name);
    wp_localize_script($this->plugin_name, 'wpReactPluginBoilerplateBuild', $localize);
  }


  /**
   * Register settings.
   * Common callback function of rest_api_init and admin_init
   * Schema: http://json-schema.org/draft-04/schema#
   *
   * Add your own settings fields here
   *
   * @since 1.0.0
   *
   * @param null.
   * @return void
   */
  public function register_settings()
  {
    $defaults = seolaxy_ctr_default_options();

    $categories = get_categories(array('hide_empty' => 0));

    /* echo "<pre>";
    print_r($categories);
    echo "</pre>";
    die(); */

    $properties = array(
      /*===Settings===*/
      /*Main Rich Snippet*/
      'type_choose' => array(
        'type' => 'string',
        'default' => $defaults['type_choose'],
        'sanitize_callback' => 'sanitize_key',
      ),
      'first_and_last_name' => array(
        'type' => 'string',
        'default' => $defaults['first_and_last_name']
      ),
      'website_name' => array(
        'type' => 'string',
        'default' => $defaults['website_name']
      ),
      'brand_name' => array(
        'type' => 'string',
        'default' => $defaults['brand_name']
      ),
      'company_name' => array(
        'type' => 'string',
        'default' => $defaults['company_name']
      ),
      'company_address' => array(
        'type' => 'string',
        'default' => $defaults['company_address']
      ),
      'country' => array(
        'type' => 'string',
        'default' => $defaults['country']
      ),
      'state' => array(
        'type' => 'string',
        'default' => $defaults['state']
      ),
      'postal_code' => array(
        'type' => 'string',
        'default' => $defaults['postal_code']
      ),
      'city' => array(
        'type' => 'string',
        'default' => $defaults['city']
      ),
      'email_address' => array(
        'type' => 'string',
        'default' => $defaults['email_address']
      ),
      'phone' => array(
        'type' => 'string',
        'default' => $defaults['phone']
      ),
      'social_profile_1' => array(
        'type' => 'string',
        'default' => $defaults['social_profile_1']
      ),
      'social_profile_2' => array(
        'type' => 'string',
        'default' => $defaults['social_profile_2']
      ),
      'blog_description' => array(
        'type' => 'string',
        'default' => $defaults['blog_description']
      ),
      'organization_logo' => array(
        'type' => 'string',
        'default' => $defaults['organization_logo']
      ),
      'homepage_title_tag' => array(
        'type' => 'string',
        'default' => $defaults['homepage_title_tag']
      ),
      'homepage_meta_description' => array(
        'type' => 'string',
        'default' => $defaults['homepage_meta_description']
      ),
      'featured_image' => array(
        'type' => 'string',
        'default' => $defaults['featured_image']
      ),
      'favicon' => array(
        'type' => 'string',
        'default' => $defaults['favicon']
      ),
      'separator' => array(
        'type' => 'string',
        'default' => $defaults['separator']
      ),
      'post_title_tag_pattern' => array(
        'type' => 'string',
        'default' => $defaults['post_title_tag_pattern']
      ),
      'post_title_tag_pattern_recommended' => array(
        'type' => 'boolean',
        'default' => $defaults['post_title_tag_pattern_recommended']
      ),
      'post_meta_description' => array(
        'type' => 'string',
        'default' => $defaults['post_meta_description']
      ),
      'post_meta_description_empty' => array(
        'type' => 'string',
        'default' => $defaults['post_meta_description_empty']
      ),
      'post_meta_description_preview' => array(
        'type' => 'boolean',
        'default' => $defaults['post_meta_description_preview']
      ),
      'page_title_tag_pattern' => array(
        'type' => 'string',
        'default' => $defaults['page_title_tag_pattern']
      ),
      'page_title_tag_pattern_recommended' => array(
        'type' => 'boolean',
        'default' => $defaults['page_title_tag_pattern_recommended']
      ),
      'page_meta_description' => array(
        'type' => 'string',
        'default' => $defaults['page_meta_description']
      ),
      'page_meta_description_empty' => array(
        'type' => 'string',
        'default' => $defaults['page_meta_description_empty']
      ),
      'page_meta_description_preview' => array(
        'type' => 'boolean',
        'default' => $defaults['page_meta_description_preview']
      ),

      'tag_title_tag_pattern' => array(
        'type' => 'string',
        'default' => $defaults['tag_title_tag_pattern']
      ),
      'tag_title_tag_pattern_recommended' => array(
        'type' => 'boolean',
        'default' => $defaults['tag_title_tag_pattern_recommended']
      ),
      'tag_meta_description_pattern' => array(
        'type' => 'string',
        'default' => $defaults['tag_meta_description_pattern']
      ),
      'tag_meta_description_pattern_recommended' => array(
        'type' => 'boolean',
        'default' => $defaults['tag_meta_description_pattern_recommended']
      ),
      'tag_meta_description_preview' => array(
        'type' => 'boolean',
        'default' => $defaults['tag_meta_description_preview']
      ),
      'author_rich_shippet_post' => array(
        'type' => 'boolean',
        'default' => $defaults['author_rich_shippet_post']
      ),
      'author_rich_shippet_page' => array(
        'type' => 'boolean',
        'default' => $defaults['author_rich_shippet_page']
      ),

      'linked_author_profile' => array(
        'type' => 'string',
        'default' => $defaults['linked_author_profile'],
        'sanitize_callback' => 'sanitize_key',
      ),
    );

    /* $properties['category_meta'] = array(
      'type' => 'object',
      'properties' => array()
    );

    foreach ($categories as $category) {
      $properties['category_meta'][$category->slug] = array(
        'type' => 'object',
        'properties' => array(
          'meta_title' => array(
            'type' => 'string',
          ),
          'meta_description' => array(
            'type' => 'string',
          ),
        )
      );
    } */
    $properties['category_meta'] = array(
      'type' => 'object',
      'properties' => array() // Initialize with an empty array
    );

    foreach ($categories as $category) {
      $properties['category_meta']['properties'][$category->slug] = array(
        'type' => 'object',
        'properties' => array(
          'meta_title' => array(
            'type' => 'string',
          ),
          'meta_description' => array(
            'type' => 'string',
          ),
        )
      );
    }
    register_setting(
      'seolaxy_ctr_settings_group',
      'seolaxy_ctr_options',
      array(
        'type' => 'object',
        'default' => $defaults,
        'show_in_rest' => array(
          'schema' => array(
            'type' => 'object',
            'properties' => $properties
          ),
        ),
      )
    );
  }
}
