<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.seolaxy.com/
 * @since             0.0.1
 * @package           Seolaxy_Crawler_Budget_Control
 *
 * @wordpress-plugin
 * Plugin Name:       SEOLAXY Crawler Budget Control
 * Plugin URI:        https://www.seolaxy.com/
 * Description:       Optimize Your Site's Crawl Efficiency with SEOLAXY Crawler Budget Control.
 * Version:           1.1.16
 * Author:            SEOLAXY
 * Author URI:        https://www.seolaxy.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       seolaxy-crawler-budget-control
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
  die;
}

define('SEOLAXY_CRAWLER_BUDGET_CONTROL_PATH', plugin_dir_path(__FILE__));
define('SEOLAXY_CRAWLER_BUDGET_CONTROL_URL', plugin_dir_url(__FILE__));
define('SEOLAXY_CRAWLER_BUDGET_CONTROL_VERSION', '1.1.16');

require 'plugin-update-checker-5.5/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

$myUpdateChecker = PucFactory::buildUpdateChecker(
  'https://plugins-cdn.seolaxy.com/crawler-budget-control/version.json',
  __FILE__,
  'seolaxy-crawler-budget-control'
);

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-seolaxy-crawler-budget-control-activator.php
 */
function activate_seolaxy_crawler_budget_control()
{
  require_once SEOLAXY_CRAWLER_BUDGET_CONTROL_PATH . 'includes/class-seolaxy-crawler-budget-control-activator.php';
  Seolaxy_Crawler_Budget_Control_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-seolaxy-crawler-budget-control-deactivator.php
 */
function deactivate_seolaxy_crawler_budget_control()
{
  require_once SEOLAXY_CRAWLER_BUDGET_CONTROL_PATH . 'includes/class-seolaxy-crawler-budget-control-deactivator.php';
  Seolaxy_Crawler_Budget_Control_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_seolaxy_crawler_budget_control');
register_deactivation_hook(__FILE__, 'deactivate_seolaxy_crawler_budget_control');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require SEOLAXY_CRAWLER_BUDGET_CONTROL_PATH . 'includes/class-seolaxy-crawler-budget-control.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * WOOCOMMERCE COMPATIBILITY:
 * This plugin is designed to work with or without WooCommerce.
 * WooCommerce-specific features are protected by seolaxy_crawler_budget_control_is_woocommerce_active() checks
 * to prevent fatal errors when WooCommerce is not active.
 *
 * Protection levels implemented:
 * 1. Core class: add_custom_fields_to_all_attributes() method
 * 2. Public hooks: WooCommerce-specific hooks conditionally registered
 * 3. Public methods: All WooCommerce function calls protected
 *
 * @since    1.0.0
 */
function run_seolaxy_crawler_budget_control()
{
  // Load the plugin with or without WooCommerce
  // WooCommerce-specific features will be conditionally loaded
  $plugin = new Seolaxy_Crawler_Budget_Control();
  $plugin->run();
}
run_seolaxy_crawler_budget_control();
