<?php

/**
 * Logger service for the plugin.
 *
 * @link       https://www.seolaxy.com/
 * @since      1.0.0
 *
 * @package    Seolaxy_Crawler_Budget_Control
 * @subpackage Seolaxy_Crawler_Budget_Control/includes/services
 */

class Seolaxy_Crawler_Budget_Control_Logger_Service
{
    /**
     * WC_Logger instance
     *
     * @var WC_Logger|null
     */
    private $logger = null;

    /**
     * Source context for logs
     * 
     * @var array
     */
    private $context;

    /**
     * Initialize the logger service
     */
    public function __construct()
    {
        $this->context = array('source' => 'seolaxy-crawler-budget-control-woo');
    }

    /**
     * Get WooCommerce logger instance
     *
     * @return WC_Logger|null
     */
    private function get_logger()
    {
        if ($this->logger === null) {
            if (class_exists('WooCommerce') && function_exists('wc_get_logger')) {
                $this->logger = wc_get_logger();
            }
        }
        return $this->logger;
    }

    /**
     * Log a message with specified level
     *
     * @param string $message The message to log
     * @param string $level The log level
     * @return void
     */
    private function log($message, $level)
    {
        $logger = $this->get_logger();
        if ($logger) {
            $logger->$level($message, $this->context);
        } else {
            error_log("[Seolaxy CRAWLER BUDGET CONTROL Woo][" . ucfirst($level) . "] " . $message);
        }
    }

    /**
     * Log an info message
     *
     * @param string $message
     * @return void
     */
    public function info($message)
    {
        if (!defined('SEOLAXY_DEV') || !SEOLAXY_DEV) {
            return;
        }

        $this->log($message, 'info');
    }

    /**
     * Log a warning message
     *
     * @param string $message
     * @return void
     */
    public function warning($message)
    {
        $this->log($message, 'warning');
    }

    /**
     * Log an error message
     *
     * @param string $message
     * @return void
     */
    public function error($message)
    {
        $this->log($message, 'error');
    }

    /**
     * Log a debug message
     *
     * @param string $message
     * @return void
     */
    public function debug($message)
    {
        if (!defined('SEOLAXY_DEV') || !SEOLAXY_DEV) {
            return;
        }

        $this->log($message, 'debug');
    }
}
