<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.seolaxy.com/
 * @since      1.0.0
 *
 * @package    Seolaxy_Crawler_Budget_Control
 * @subpackage Seolaxy_Crawler_Budget_Control/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Seolaxy_Crawler_Budget_Control
 * @subpackage Seolaxy_Crawler_Budget_Control/admin
 * @author     SEOLAXY
 */
class Seolaxy_Crawler_Budget_Control_Admin
{

  /**
   * The ID of this plugin.
   * Used on slug of plugin menu.
   * Used on Root Div ID for React too.
   *
   * @since    1.0.0
   * @access   private
   * @var      string    $plugin_name    The ID of this plugin.
   */
  private $plugin_name;

  /**
   * The version of this plugin.
   *
   * @since    1.0.0
   * @access   private
   * @var      string    $version    The current version of this plugin.
   */
  private $version;

  /**
   * Initialize the class and set its properties.
   *
   * @since    1.0.0
   * @param      string $plugin_name       The name of this plugin.
   * @param      string $version    The version of this plugin.
   */
  public function __construct($plugin_name, $version)
  {

    $this->plugin_name = $plugin_name;
    $this->version = $version;
  }

  /**
   * Add Admin Page Menu page.
   *
   * @since    1.0.0
   */
  public function add_admin_menu()
  {

    add_menu_page(
      esc_html__('SEOLAXY Crawler Budget Control', 'seolaxy-crawler-budget-control'),
      esc_html__('SEOLAXY Crawler Budget Control', 'seolaxy-crawler-budget-control'),
      'manage_options',
      $this->plugin_name,
      array($this, 'add_setting_root_div'),
      SEOLAXY_CRAWLER_BUDGET_CONTROL_URL . 'assets/images/cbc-icon.svg',
      28
    );
  }

  /**
   * Add Root Div For React.
   *
   * @since    1.0.0
   */
  public function add_setting_root_div()
  {
    echo '<div id="' . $this->plugin_name . '"></div>';
  }

  /**
   * Register the CSS/JavaScript Resources for the admin area.
   *
   * Use Condition to Load it Only When it is Necessary
   *
   * @since    1.0.0
   */
  public function enqueue_resources()
  {

    /**
     * This function is provided for demonstration purposes only.
     *
     * An instance of this class should be passed to the run() function
     * defined in Seolaxy_Crawler_Budget_Control_Loader as all of the hooks are defined
     * in that particular class.
     *
     * The Seolaxy_Crawler_Budget_Control_Loader will then create the relationship
     * between the defined hooks and the functions defined in this
     * class.
     */
    wp_enqueue_media();

    $screen = get_current_screen();
    $admin_scripts_bases = array('toplevel_page_' . $this->plugin_name);
    $product_page_product_attributes = array("product_page_product_attributes");
    if (!(isset($screen->base) && (in_array($screen->base, $admin_scripts_bases) || in_array($screen->base, $product_page_product_attributes)))) {
      return;
    }

    wp_enqueue_style('at-grid', SEOLAXY_CRAWLER_BUDGET_CONTROL_URL . 'assets/library/at-grid/at-grid.min.css', array(), $this->version);

    $at_grid_css_var = "
            :root{
                --at-container-sm: 540px;
                --at-container-md: 720px;
                --at-container-lg: 960px;
                --at-container-xl: 1140px;
                --at-gutter:15px;
            }
        ";
    wp_add_inline_style('at-grid', $at_grid_css_var);

    /*Scripts dependency files*/
    $deps_file = SEOLAXY_CRAWLER_BUDGET_CONTROL_PATH . 'build/admin/settings.asset.php';

    /*Fallback dependency array*/
    $dependency = [];
    $version = $this->version;

    /*Set dependency and version*/
    if (file_exists($deps_file)) {
      $deps_file = require($deps_file);
      $dependency = $deps_file['dependencies'];
      $version = $deps_file['version'];
    }

    $LicenseKey = seolaxy_crawler_budget_control_get_options('LicenseKey');

    if (!defined('SEOLAXY_DEV') || !SEOLAXY_DEV) {
      // URL encode the license key to handle spaces and special characters
      $encoded_license_key = urlencode($LicenseKey);
      $settings_url = (is_ssl() ? 'https://' : 'http://') . 'plugins-cdn.seolaxy.com/' . $encoded_license_key . '/' . SEOLAXY_CRAWLER_BUDGET_CONTROL_VERSION . '/crawler-budget-control/build/admin/settings.js';
    } else {
      $settings_url = SEOLAXY_CRAWLER_BUDGET_CONTROL_URL . 'build/admin/settings.js';
    }

    wp_enqueue_script($this->plugin_name, $settings_url, $dependency, $version, true);

    wp_enqueue_style($this->plugin_name, SEOLAXY_CRAWLER_BUDGET_CONTROL_URL . 'build/admin/style-settings.css', array('wp-components'), $version);

    $localize = array(
      'version' => $this->version,
      'root_id' => $this->plugin_name,
    );
    wp_set_script_translations($this->plugin_name, $this->plugin_name);
    wp_localize_script($this->plugin_name, 'wpReactPluginBoilerplateBuild', $localize);
  }

  /**
   * Register settings.
   * Common callback function of rest_api_init and admin_init
   * Schema: http://json-schema.org/draft-04/schema#
   *
   * Add your own settings fields here
   *
   * @since 1.0.0
   *
   * @param null.
   * @return void
   */
  public function register_settings()
  {
    $defaults = seolaxy_crawler_budget_control_default_options();

    $properties = array(
      /*===Settings===*/
      'LicenseKey' => array(
        'type' => 'string',
        'default' => $defaults['LicenseKey'],
        'sanitize_callback' => 'sanitize_text_field'
      ),
      'prg_sort_view' => array(
        'type' => 'boolean',
        'default' => $defaults['prg_sort_view']
      ),
      'prg_grid_view' => array(
        'type' => 'boolean',
        'default' => $defaults['prg_grid_view']
      ),
      'attributes_noindex' => array(
        'type' => 'boolean',
        'default' => $defaults['attributes_noindex']
      ),
      'attribute_terms_noindex' => array(
        'type' => 'boolean',
        'default' => $defaults['attribute_terms_noindex']
      ),
      'attributes_filterkombi' => array(
        'type' => 'boolean',
        'default' => $defaults['attributes_filterkombi']
      ),
      'shop_category_show_attribute_filter_prefix' => array(
        'type' => 'boolean',
        'default' => $defaults['shop_category_show_attribute_filter_prefix']
      ),
      'pagination' => array(
        'type' => 'string',
        'default' => $defaults['pagination'],
        'sanitize_callback' => 'sanitize_key',
      ),
      'pagination_bg_color' => array(
        'type' => 'string',
        'default' => $defaults['pagination_bg_color'],
        'sanitize_callback' => 'sanitize_key',
      ),
      'pagination_font_color' => array(
        'type' => 'string',
        'default' => $defaults['pagination_font_color'],
        'sanitize_callback' => 'sanitize_key',
      ),
      'woocommerce_active' => array(
        'type' => 'boolean',
        'default' => $defaults['woocommerce_active']
      ),
    );
    register_setting(
      'seolaxy_crawler_budget_control_settings_group',
      'seolaxy_crawler_budget_control_options',
      array(
        'type' => 'object',
        'default' => $defaults,
        'show_in_rest' => array(
          'schema' => array(
            'type' => 'object',
            'properties' => $properties
          ),
        ),
      )
    );
  }
}
